#ifndef __C_PBCASTLAYERPARAM_H
#define __C_PBCASTLAYERPARAM_H

#define WIN32_LEAN_AND_MEAN

#include "Interfaces/cParam.h"
//#include <winsock2.h>

/*
 * cPbcastLayerParam.h
 *
 * Parameter set for the network layer.
 */
class cPbcastLayerParam : public cParam
{
  public:

	cPbcastLayerParam() { ResetToDefault(); }

	void ResetToDefault()
	{
		mSubnetList						= NULL;
		mMsgQueueSize					= 32768;
		mMsgQueueGrowInc				= 32768;
		mMaxBytesRetransmitPerRound		= 4096;
		mMaxRetransRequestsPerRound		= 16;	
		mNumRetransmitRequestAttempts	= 5;
		mProbFailMistake				= 1e-6;
		mMaxBandwidth					= 500;	// bytes/second
		mMulticastEndpoint				= NULL;
	}

	// Values
	cGroup*			mSubnetList;					// Starter list of subnets
	unsigned int	mMsgQueueSize;					// Initial size of the message queue.
	unsigned int	mMsgQueueGrowInc;				// The rate at which the message queue can grow.
	unsigned int	mMaxBytesRetransmitPerRound;	// The maximum number of bytes that can be retransmitted for each round.
	unsigned int	mMaxRetransRequestsPerRound;	// Maximum number of retransmits that can be requested per round.
	unsigned int	mNumRetransmitRequestAttempts;	// The number of times to request a msg retransmit before
													//   giving up.
	double			mProbFailMistake;				// The probability of making a mistake in detecting failure.
	unsigned int	mMaxBandwidth;					// In bytes/second
	cEndpoint*		mMulticastEndpoint;				// The multicast address.
};

typedef struct PbcastParams
{
	cEndpoint*	  mMcastEp;
	unsigned int  mMaxBytesRetransmitPerRound;
	unsigned int  mNumRetransmitRequestAttempts;
	unsigned int  mMaxRetransRequestsPerRound;
	unsigned int  mFanout;
	unsigned int  mSubnetTreeFanout;
	DWORD		  mGossipInterval;
	DWORD		  mTimeToFailNode;
	DWORD		  mTimeToCleanupNode;
	DWORD		  mTimeToCleanupMsg;
	unsigned int  mNumRetansReq;
	unsigned int  mNumRetransRecvd;
	unsigned int  mViewSize;
	unsigned int  mSubnetListSize;
	unsigned int  mMinGossipsSent;
	unsigned int  mFullGossipsSent;
	unsigned int  mMinGossipsReceived;
	unsigned int  mFullGossipsReceived;
	unsigned int  mPbcastsSent;
	unsigned int  mPbcastsRecvd;
	double		  mMaxBandwidth;
	double		  mProbFailMistake;
} PbcastParams;

#endif